<?php
/* ------------------------------------- */
/* PAGE/POST/PORTFOLIO OPTIONS */
/* ------------------------------------- */

// Prefix for  Page/Post/Portfolio Options
$prefix="alterego_";

// Load the Page Option Meta Fields
$custom_meta_fields=array();
require_once(alterego_FUNCTIONS . '/page_options/theme_page_custom_meta.php');
require_once(alterego_FUNCTIONS . '/page_options/theme_post_custom_meta.php');
require_once(alterego_FUNCTIONS . '/page_options/theme_portfolio_custom_meta.php');

// Generate Page/Post/Portfolio Options
add_action('admin_init', 'init_page_options');

function init_page_options() {
	// Page Options Build Boxes
		add_meta_box("page-basic-options", "Page Options", "show_custom_page_basic_meta_fields_box", "page", "normal", "high");
		add_meta_box("page-head-options", "Head Block", "show_custom_page_head_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-teaser-options", "Home Teasers", "show_custom_page_teaser_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-taglines-options", "Taglines", "show_custom_page_elements_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-partners-options", "Partners", "show_custom_partners_elements_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-sidebar-options", "Sidebar", "show_custom_page_sidebar_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-background-options", "Background", "show_custom_page_background_meta_fields_box", "page", "normal", "low");
		add_meta_box("page-portfolio-options", "Portfolio", "show_custom_page_portfolio_meta_fields_box", "page", "normal", "high");

	// Post Options Build Boxes
		add_meta_box("post-basic-options", "Post Options", "show_custom_post_basic_meta_fields_box", "post", "normal", "low");
		add_meta_box("post-type-options", "Post Type Options", "show_custom_post_type_meta_fields_box", "post", "normal", "low");
		add_meta_box("post-head2-options", "Head Block", "show_custom_post_head_meta_fields_box", "post", "normal", "low");
		add_meta_box("post-sidebar2-options", "Sidebar", "show_custom_post_sidebar_meta_fields_box", "post", "normal", "low");
		add_meta_box("post-background-options", "Background", "show_custom_post_background_meta_fields_box", "post", "normal", "low");
		

	// Special Options for Portfolio Pages
		$portfolio_slugs = get_option("alterego_portfolio_slug");
		if(is_array($portfolio_slugs))
			foreach ( $portfolio_slugs as $slug ){
			   // Post Options Build Boxes
				add_meta_box("post-basic-options", "Post Options", "show_custom_portfolio_basic_meta_fields_box", $slug , "normal", "high");
				add_meta_box("post-type-options", "Post Type Options", "show_custom_portfolio_type_meta_fields_box", $slug, "normal", "high");
				add_meta_box("post-head-options", "Head Block", "show_custom_portfolio_head_meta_fields_box", $slug, "normal", "low");
				add_meta_box("post-sidebar-options", "Sidebar", "show_custom_portfolio_sidebar_meta_fields_box", $slug, "normal", "low");
				add_meta_box("post-background-options", "Background", "show_custom_portfolio_background_meta_fields_box", $slug, "normal", "low"); 
			}
}

// Include the Page Option Framework Functions
require_once(alterego_FUNCTIONS . '/page_options/theme_page_options_functions.php');
?>